<?php
/**
 * Class that operate on table 'onlineproductcat'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2025-05-13 06:09
 */
class OnlineproductcatMySqlDAO implements OnlineproductcatDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return OnlineproductcatMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM onlineproductcat WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM onlineproductcat';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM onlineproductcat ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param onlineproductcat primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM onlineproductcat WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param OnlineproductcatMySql onlineproductcat
 	 */
	public function insert($onlineproductcat){
		$sql = 'INSERT INTO onlineproductcat (parentid, title, titleEn, description, descriptionEn, image, sysDate, userid, isdel) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($onlineproductcat->parentid);
		$sqlQuery->set($onlineproductcat->title);
		$sqlQuery->set($onlineproductcat->titleEn);
		$sqlQuery->setString2($onlineproductcat->description);
		$sqlQuery->setString2($onlineproductcat->descriptionEn);
		$sqlQuery->set($onlineproductcat->image);
		$sqlQuery->set($onlineproductcat->sysDate);
		$sqlQuery->setNumber($onlineproductcat->userid);
		$sqlQuery->setNumber($onlineproductcat->isdel);

		$id = $this->executeInsert($sqlQuery);	
		$onlineproductcat->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param OnlineproductcatMySql onlineproductcat
 	 */
	public function update($onlineproductcat){
		$sql = 'UPDATE onlineproductcat SET parentid = ?, title = ?, titleEn = ?, description = ?, descriptionEn = ?, image = ?, sysDate = ?, userid = ?, isdel = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($onlineproductcat->parentid);
		$sqlQuery->set($onlineproductcat->title);
		$sqlQuery->set($onlineproductcat->titleEn);
		$sqlQuery->setString2($onlineproductcat->description);
		$sqlQuery->setString2($onlineproductcat->descriptionEn);
		$sqlQuery->set($onlineproductcat->image);
		$sqlQuery->set($onlineproductcat->sysDate);
		$sqlQuery->setNumber($onlineproductcat->userid);
		$sqlQuery->setNumber($onlineproductcat->isdel);

		$sqlQuery->setNumber($onlineproductcat->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM onlineproductcat';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByParentid($value){
		$sql = 'SELECT * FROM onlineproductcat WHERE parentid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTitle($value){
		$sql = 'SELECT * FROM onlineproductcat WHERE title = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTitleEn($value){
		$sql = 'SELECT * FROM onlineproductcat WHERE titleEn = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDescription($value){
		$sql = 'SELECT * FROM onlineproductcat WHERE description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDescriptionEn($value){
		$sql = 'SELECT * FROM onlineproductcat WHERE descriptionEn = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByImage($value){
		$sql = 'SELECT * FROM onlineproductcat WHERE image = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysDate($value){
		$sql = 'SELECT * FROM onlineproductcat WHERE sysDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM onlineproductcat WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByIsdel($value){
		$sql = 'SELECT * FROM onlineproductcat WHERE isdel = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByParentid($value){
		$sql = 'DELETE FROM onlineproductcat WHERE parentid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTitle($value){
		$sql = 'DELETE FROM onlineproductcat WHERE title = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTitleEn($value){
		$sql = 'DELETE FROM onlineproductcat WHERE titleEn = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDescription($value){
		$sql = 'DELETE FROM onlineproductcat WHERE description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDescriptionEn($value){
		$sql = 'DELETE FROM onlineproductcat WHERE descriptionEn = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByImage($value){
		$sql = 'DELETE FROM onlineproductcat WHERE image = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysDate($value){
		$sql = 'DELETE FROM onlineproductcat WHERE sysDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM onlineproductcat WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByIsdel($value){
		$sql = 'DELETE FROM onlineproductcat WHERE isdel = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return OnlineproductcatMySql 
	 */
	protected function readRow($row){
		$onlineproductcat = new Onlineproductcat();
		
		$onlineproductcat->id = $row['id'];
		$onlineproductcat->parentid = $row['parentid'];
		$onlineproductcat->title = $row['title'];
		$onlineproductcat->titleEn = $row['titleEn'];
		$onlineproductcat->description = $row['description'];
		$onlineproductcat->descriptionEn = $row['descriptionEn'];
		$onlineproductcat->image = $row['image'];
		$onlineproductcat->sysDate = $row['sysDate'];
		$onlineproductcat->userid = $row['userid'];
		$onlineproductcat->isdel = $row['isdel'];

		return $onlineproductcat;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return OnlineproductcatMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>